/*
 * Read bits and write them as characters into a text area.
 *
 * Written by Matthew Kwan - September 1997
 */

import java.awt.TextArea;

class SnowOutput extends BitFilter {
	private TextArea	text_area = null;
	private	int		bit_count;
	private	int		value;

	SnowOutput (TextArea ta) {
	    text_area = ta;

	    bit_count = 0;
	    value = 0;
	}

	public boolean		receive_bit (boolean bit) {
	    value = (value << 1) | (bit ? 1 : 0);

	    if (++bit_count == 8) {
		byte	b[] = new byte[1];

		b[0] = (byte) value;
		text_area.append (new String (b));

		value = 0;
		bit_count = 0;
	    }

	    return (true);
	}

	public boolean		flush () {
	    return (true);
	}
}
