/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;

class SnowOutput
extends BitFilter {
    private boolean quiet_flag = false;
    private OutputStream stream_out;
    private int bit_count;
    private int value;

    SnowOutput(boolean bl, OutputStream outputStream) {
        this.quiet_flag = bl;
        this.stream_out = outputStream;
        this.bit_count = 0;
        this.value = 0;
    }

    public boolean receive_bit(boolean bl) {
        this.value = this.value << 1 | (bl ? 1 : 0);
        if (++this.bit_count == 8) {
            try {
                this.stream_out.write(this.value);
            }
            catch (IOException iOException) {
                System.err.println("Error: failed to write output.");
                return false;
            }
            this.value = 0;
            this.bit_count = 0;
        }
        return true;
    }

    public boolean flush() {
        if (this.bit_count > 2 && !this.quiet_flag) {
            System.err.println("Warning: residual of " + this.bit_count + " bits not output.");
        }
        return true;
    }
}

