/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

class SnowEncode
extends BitFilter {
    private boolean encode_flag = false;
    private boolean quiet_flag = false;
    private BitFilter next_filter;
    private BufferedReader stream_in;
    private PrintWriter stream_out;
    private int line_length;
    private int bit_count;
    private int value;
    private char[] buffer;
    private boolean buffer_loaded;
    private int buffer_length;
    private int buffer_column;
    private boolean first_tab;
    private boolean needs_tab;
    private int bits_used;
    private int bits_available;
    private int lines_extra;

    SnowEncode(boolean bl, boolean bl2, BitFilter bitFilter, BufferedReader bufferedReader, PrintWriter printWriter, int n) {
        this.encode_flag = bl;
        this.quiet_flag = bl2;
        this.next_filter = bitFilter;
        this.stream_in = bufferedReader;
        this.stream_out = printWriter;
        this.line_length = n;
        this.bit_count = 0;
        this.value = 0;
        this.buffer = new char[4096];
        this.buffer_loaded = false;
        this.buffer_length = 0;
        this.buffer_column = 0;
        this.first_tab = false;
        this.bits_used = 0;
        this.bits_available = 0;
        this.lines_extra = 0;
    }

    private int tabpos(int n) {
        return n + 8 & 0xFFFFFFF8;
    }

    private int wsgets(BufferedReader bufferedReader, char[] cArray) {
        String string;
        try {
            string = bufferedReader.readLine();
            if (string == null) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        int n = string.length();
        while (n > 0) {
            if (string.charAt(n - 1) > ' ') break;
            --n;
        }
        if (n == 0) {
            return 0;
        }
        string.getChars(0, n, cArray, 0);
        return n;
    }

    private boolean wsputs(PrintWriter printWriter, char[] cArray, int n) {
        printWriter.write(cArray, 0, n);
        printWriter.println();
        return !printWriter.checkError();
    }

    private void whitespace_storage(int n, int[] nArray) {
        if (n > this.line_length - 2) {
            return;
        }
        if (n / 8 == this.line_length / 8) {
            nArray[1] = nArray[1] + 3;
            return;
        }
        if ((n & 7) > 0) {
            nArray[1] = nArray[1] + 3;
            n = this.tabpos(n);
        }
        if ((this.line_length & 7) > 0) {
            nArray[1] = nArray[1] + 3;
        }
        int n2 = (this.line_length - n) / 8 * 3;
        nArray[1] = nArray[1] + n2;
        nArray[0] = nArray[0] + n2;
    }

    private void buffer_load(BufferedReader bufferedReader) {
        this.buffer_length = this.wsgets(bufferedReader, this.buffer);
        if (this.buffer_length < 0) {
            this.buffer_length = 0;
            ++this.lines_extra;
        }
        this.buffer_column = 0;
        int n = 0;
        while (n < this.buffer_length) {
            this.buffer_column = this.buffer[n] == '\t' ? this.tabpos(this.buffer_column) : ++this.buffer_column;
            ++n;
        }
        this.buffer_loaded = true;
        this.needs_tab = false;
    }

    private boolean append_whitespace(int n) {
        int n2 = this.buffer_column;
        if (this.needs_tab) {
            n2 = this.tabpos(n2);
        }
        n2 = n == 0 ? this.tabpos(n2) : (n2 += n);
        if (n2 >= this.line_length) {
            return false;
        }
        if (this.needs_tab) {
            this.buffer[this.buffer_length++] = 9;
            this.buffer_column = this.tabpos(this.buffer_column);
        }
        if (n == 0) {
            this.buffer[this.buffer_length++] = 9;
            this.buffer_column = this.tabpos(this.buffer_column);
            this.needs_tab = false;
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.buffer[this.buffer_length++] = 32;
                ++this.buffer_column;
                ++n3;
            }
            this.needs_tab = true;
        }
        return true;
    }

    private boolean write_value(int n) {
        if (!this.buffer_loaded) {
            this.buffer_load(this.stream_in);
        }
        if (!this.first_tab) {
            while (this.tabpos(this.buffer_column) >= this.line_length) {
                if (!this.wsputs(this.stream_out, this.buffer, this.buffer_length)) {
                    return false;
                }
                this.buffer_load(this.stream_in);
            }
            this.buffer[this.buffer_length++] = 9;
            this.buffer_column = this.tabpos(this.buffer_column);
            this.first_tab = true;
        }
        int n2 = (n & 1) << 2 | n & 2 | (n & 4) >> 2;
        while (!this.append_whitespace(n2)) {
            if (!this.wsputs(this.stream_out, this.buffer, this.buffer_length)) {
                return false;
            }
            this.buffer_load(this.stream_in);
        }
        if (this.lines_extra == 0) {
            this.bits_available += 3;
        }
        return true;
    }

    public boolean receive_bit(boolean bl) {
        if (this.encode_flag) {
            this.value = this.value << 1 | (bl ? 1 : 0);
            ++this.bits_used;
            if (++this.bit_count == 3) {
                if (!this.write_value(this.value)) {
                    return false;
                }
                this.value = 0;
                this.bit_count = 0;
            }
            return true;
        }
        return false;
    }

    public boolean flush() {
        int n;
        if (!this.encode_flag) {
            return this.next_filter.flush();
        }
        if (this.bit_count > 0) {
            while (this.bit_count < 3) {
                this.value <<= 1;
                ++this.bit_count;
            }
            if (!this.write_value(this.value)) {
                return false;
            }
        }
        if (this.buffer_loaded) {
            if (!this.wsputs(this.stream_out, this.buffer, this.buffer_length)) {
                return false;
            }
            this.buffer_loaded = false;
            this.buffer_length = 0;
            this.buffer_column = 0;
        }
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = 0;
        while ((n = this.wsgets(this.stream_in, this.buffer)) >= 0) {
            this.whitespace_storage(n, nArray);
            if (this.wsputs(this.stream_out, this.buffer, n)) continue;
            return false;
        }
        this.bits_available += (nArray[0] + nArray[1]) / 2;
        if (!this.quiet_flag) {
            double d = 100.0 * (double)this.bits_used / (double)this.bits_available;
            d = Math.rint(d * 100.0) / 100.0;
            if (this.lines_extra > 0) {
                System.err.println("Message exceeded available space by approximately " + (d - 100.0) + "%.");
                System.err.println("An extra  " + this.lines_extra + " lines were added.");
            } else {
                System.err.println("Message used approximately " + d + "% of available space.");
            }
        }
        return true;
    }

    private boolean decode_bits(int n) {
        if (n > 7) {
            System.err.println("Illegal encoding of " + n + " spaces.");
            return false;
        }
        if (!this.next_filter.receive_bit((n & 1) != 0)) {
            return false;
        }
        if (!this.next_filter.receive_bit((n & 2) != 0)) {
            return false;
        }
        return this.next_filter.receive_bit((n & 4) != 0);
    }

    private boolean decode_whitespace(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (this.buffer[n4] == '\t') {
                if (!this.decode_bits(n3)) {
                    return false;
                }
                n3 = 0;
            } else if (this.buffer[n4] == ' ') {
                ++n3;
            }
            ++n4;
        }
        return n3 <= 0 || this.decode_bits(n3);
    }

    private int read_whitespace(BufferedReader bufferedReader, char[] cArray) {
        String string;
        try {
            string = bufferedReader.readLine();
            if (string == null) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        int n = string.length();
        while (n > 0 && string.charAt(n - 1) == '\n') {
            --n;
        }
        int n2 = n;
        while (n2 > 0) {
            if (string.charAt(n2 - 1) > ' ') break;
            --n2;
        }
        if (n2 == n) {
            return 0;
        }
        string.getChars(n2, n, cArray, 0);
        return n - n2;
    }

    public boolean decode() {
        int n;
        boolean bl = false;
        while ((n = this.read_whitespace(this.stream_in, this.buffer)) >= 0) {
            int n2 = 0;
            if (n == 0 || !bl && this.buffer[0] == ' ') continue;
            if (!bl && this.buffer[0] == '\t') {
                bl = true;
                n2 = 1;
                if (n == 1) continue;
            }
            if (this.decode_whitespace(n2, n)) continue;
            return false;
        }
        return this.next_filter.flush();
    }

    public void space_calculate() {
        int n;
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = 0;
        while ((n = this.wsgets(this.stream_in, this.buffer)) >= 0) {
            this.whitespace_storage(n, nArray);
        }
        if (nArray[0] > 0) {
            nArray[0] = nArray[0] - 1;
            nArray[1] = nArray[1] - 1;
        }
        if (nArray[0] == nArray[1]) {
            System.out.println("File has storage capacity of " + nArray[0] + " bits (" + nArray[0] / 8 + " bytes)");
            return;
        }
        System.out.println("File has storage capacity of between " + nArray[0] + " and " + nArray[1] + " bits.");
        System.out.println("Approximately " + (nArray[0] + nArray[1]) / 16 + " bytes.");
    }
}

