/*
 * Perform simple operations on 8-byte blocks of data.
 *
 * Written by Matthew Kwan - April 1997
 */

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;


class Block {
		// The actual data.
	public byte	data[];


		// Constructor.
	Block () {
	    data = new byte[8];
	}


		// Write a block to the specified file.
	public boolean	write (OutputStream f) {
	    try {
		f.write (data, 0, 8);
	    } catch (IOException e) {
		System.err.println ("Failed to write output");
		return (false);
	    }

	    return (true);
	}


		// Write part of a block to the specified file.
	public boolean	write (OutputStream f, int n) {
	    try {
		f.write (data, 0, n);
	    } catch (IOException e) {
		System.err.println ("Failed to write output");
		return (false);
	    }

	    return (true);
	}


		// Read up to 8-bytes from the specified file.
		// Return the number read.
	public int	read (InputStream f) {
	    int		tot = 0;

	    try {
		int	n;

		while (tot < 8) {
		    n = f.read (data, tot, 8 - tot);
		    if (n <= 0)
			break;
		    tot += n;
		}
	    } catch (IOException e) {
	    }

	    return (tot);
	}


		// Copy an 8-byte block.
	public void	copy (Block src) {
	    for (int i=0; i<8; i++)
		data[i] = src.data[i];
	}


		// XOR an 8-byte block onto another one.
	public void	xor (Block src) {
	    for (int i=0; i<8; i++)
		data[i] ^= src.data[i];
	}


		// Pad an 8-byte block in positions n .. 7
		// The lower 3 bits of the last byte will contain the value n.
		// The padding will be an encrypted copy of the IV so as
		// to thwart a ciphertext-only attack which might look for
		// padding bytes.
	public void	pad (int n, Block pad) {
	    for (int i=n; i<8; i++)
		data[i] = pad.data[i];

	    data[7] = (byte) ((data[7] & 0xf8) | n);
	}
}
